/***************************************************
//Web: http://www.buydisplay.com
EastRising Technology Co.,LTD
Examples for ER-TFTM1.83-2
Display is Hardward SPI 4-Wire SPI Interface 
Tested and worked with: 
Works with Raspberry pi
****************************************************/

#include <bcm2835.h>
#include <stdio.h>
#include <time.h>
#include "nv3030b.h"

char value[10] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
int main(int argc, char **argv)
{
    time_t now;
    struct tm *timenow;
    FILE *pFile ;
    /* 1 pixel of 888 bitmap = 3 bytes */
    size_t pixelSize = 3;
    unsigned char bmpBuffer[TFT_WIDTH * TFT_HEIGHT * 3];

    if(!bcm2835_init())
    {
        return -1;
    }

 


  
    nv3030b_begin();
    nv3030b_mono_bitmap(57, 50, mono_bmp, 128, 128, GREEN);
    nv3030b_display();
    bcm2835_delay(2000);


   
    pFile = fopen("pic1.bmp", "r");

   if (pFile == NULL) {
        printf("file1 not exist\n");
        return 0;
    }
  
    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);



   pFile = fopen("pic2.bmp", "r");

   if (pFile == NULL) {
        printf("file2 not exist\n");
        return 0;
    }

    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);

   pFile = fopen("pic3.bmp", "r");

   if (pFile == NULL) {
        printf("file3 not exist\n");
        return 0;
    }

    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);


   pFile = fopen("pic4.bmp", "r");

   if (pFile == NULL) {
        printf("file4 not exist\n");
        return 0;
    }

    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);

   pFile = fopen("pic5.bmp", "r");

   if (pFile == NULL) {
        printf("file5 not exist\n");
        return 0;
    }

    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);


   pFile = fopen("pic6.bmp", "r");

   if (pFile == NULL) {
        printf("file6 not exist\n");
        return 0;
    }

    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);


   pFile = fopen("pic7.bmp", "r");

   if (pFile == NULL) {
        printf("file7 not exist\n");
        return 0;
    }

    fseek(pFile, 54, 0);
    fread(bmpBuffer, pixelSize, TFT_WIDTH * TFT_HEIGHT, pFile);
    fclose(pFile);

    nv3030b_bitmap24(0, 0, bmpBuffer, 240, 280);
    nv3030b_display();
    bcm2835_delay(2000);





    nv3030b_clear();
    printf("TFT example. Press Ctrl + C to exit.\n");

    uint16_t i=100;
    while(1)
    {
        time(&now);
        timenow = localtime(&now);

        nv3030b_mono_bitmap(0, 2, Signal816, 16, 8, GOLDEN); 
        nv3030b_mono_bitmap(45, 2, Msg816, 16, 8, GOLDEN); 
        nv3030b_mono_bitmap(90, 2, Bluetooth88, 8, 8, GOLDEN); 
        nv3030b_mono_bitmap(135, 2, GPRS88, 8, 8, GOLDEN); 
        nv3030b_mono_bitmap(180, 2, Alarm88, 8, 8, GOLDEN); 
        nv3030b_mono_bitmap(224, 2, Bat816, 16, 8, GOLDEN); 

        nv3030b_string(20, 264, "MUSIC", 16, 0, WHITE); 
     	nv3030b_string(80, 264, "EastRising", 16, 1, CYAN); 
        nv3030b_string(185, 264, "MENU", 16, 1, GOLDEN); 


        nv3030b_char3216(0, 140, value[timenow->tm_hour / 10],RED);
        nv3030b_char3216(30,140, value[timenow->tm_hour % 10],RED);
        nv3030b_char3216(60, 140, ':' , WHITE);
        nv3030b_char3216(90, 140, value[timenow->tm_min / 10], GREEN);
        nv3030b_char3216(120, 140, value[timenow->tm_min % 10], GREEN);
        nv3030b_char3216(150, 140, ':' , WHITE);
        nv3030b_char3216(180, 140, value[timenow->tm_sec / 10],  BLUE);
        nv3030b_char3216(210, 140, value[timenow->tm_sec % 10],  BLUE);

        nv3030b_string(48, 220, "www.buydisplay.com", 16, 1, i); 
	i+=1000; if(i>=65536)i=1000;
    
        nv3030b_display();
      
    }
    bcm2835_spi_end();
    bcm2835_close();
    return 0;
}

